package ru.yandex.chemodan.app.docviewer.config;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

import ru.yandex.chemodan.app.docviewer.utils.cache.TemporaryFileCache;
import ru.yandex.chemodan.app.docviewer.utils.cache.TemporaryFilesCleaner;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author akirakozov
 */
public class TempFileCacheContextConfiguration {

    @Bean
    public TemporaryFilesCleaner temporaryFilesCleaner(
            @Value("${temp.file.ttl}") Duration tempFileTtl,
            @Value("${temp.file.cleaner.delay}") Duration delay,
            //TODO: Change to percent instead of size
            @Value("${fs.cache.warn.free}") DataSize warnFreeSpace,
            //TODO: Change to percent instead of size
            @Value("${fs.cache.crit.free}") DataSize critFreeSpace,
            @Value("${temp.file.cleaner.attempts}") int attempts,
            @Value("${tmp.dir.office.files.prefix}") String soPrefix)
    {
        return new TemporaryFilesCleaner(tempFileTtl, delay, warnFreeSpace, critFreeSpace, attempts, soPrefix);
    }

    @Bean
    public TemporaryFileCache temporaryFileCache(
            TemporaryFilesCleaner temporaryFilesCleaner,
            @Value("${fs.cache.size}") DataSize maxCacheSize)
    {
        return new TemporaryFileCache(temporaryFilesCleaner, maxCacheSize);
    }
}
