package ru.yandex.chemodan.app.docviewer.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.docviewer.copy.provider.CrmUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.DiskPublicUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.DiskUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.DiskUrlVersioningProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.DocumentUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.FemidaUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.MailUrlProvider2;
import ru.yandex.chemodan.app.docviewer.copy.provider.MulcaUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.OtrsUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.PracticumUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.ProcuUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.RealHttpUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.SchoolbookUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.TrackerUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.UslugiUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.WikiUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.provider.YaBroUrlProvider;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.misc.ip.HostPort;

/**
 * @author akirakozov
 */
@Configuration
public class UrlProvidersContextConfiguration {

    @Bean
    public MpfsUrlHelper mpfsUrlHelper() {
        return new MpfsUrlHelper();
    }

    @Bean
    public DiskUrlProvider diskUrlProvider(MpfsUrlHelper mpfsUrlHelper) {
        return new DiskUrlProvider(mpfsUrlHelper);
    }

    @Bean
    public DiskPublicUrlProvider diskPublicUrlProvider(MpfsUrlHelper mpfsUrlHelper) {
        return new DiskPublicUrlProvider(mpfsUrlHelper);
    }

    @Bean
    public DiskUrlVersioningProvider diskUrlVersioningProvider(MpfsUrlHelper mpfsUrlHelper) {
        return new DiskUrlVersioningProvider(mpfsUrlHelper);
    }

    @Bean
    public DocumentUrlProvider mailUrlProvider(
            @Value("${wmi.host}") String wmiHost,
            @Value("${wmi.yt.host}") String wmiYtHost,
            @Value("${mail_meta.host}") String mailMetaHost,
            @Value("${yt_mail_meta.host}") String mailYtMetaHost)
    {
        return new MailUrlProvider2(wmiHost, wmiYtHost, mailMetaHost, mailYtMetaHost, 443);
    }

    @Bean
    public WikiUrlProvider yaTeamWikiUrlProvider(
            @Value("${wiki.download-url.path}") String wikiDownloadUrlPath,
            @Value("${wiki.host}") String wikiHost,
            @Value("${wiki-evaluation.host}") String wikiEvaluationHost)
    {
        return new WikiUrlProvider(wikiDownloadUrlPath, Cf.set(wikiHost, wikiEvaluationHost), true);
    }

    @Bean
    public WikiUrlProvider publicWikiUrlProvider(
            @Value("${wiki.download-url.path}") String wikiDownloadUrlPath,
            @Value("${wiki.school.host}") String wikiSchoolHost,
            @Value("${wiki.external.host}") String wikiExternalHost)
    {
        return new WikiUrlProvider(wikiDownloadUrlPath, Cf.set(wikiExternalHost, wikiSchoolHost), false);
    }

    @Bean
    public OtrsUrlProvider otrsUrlProvider(
            @Value("${mds.host-port}") HostPort mdsHostPort)
    {
        return new OtrsUrlProvider(mdsHostPort);
    }

    @Bean
    public MulcaUrlProvider mulcaUrlProvider(
            @Value("${mulca.gate.url}") String mulcaGateUrl,
            @Value("${mulca.service}") String mulcaService,
            @Value("${mulca.namespace}") String mulcaNamespace)
    {
        return new MulcaUrlProvider(mulcaGateUrl, mulcaService, mulcaNamespace);
    }

    @Bean
    public CrmUrlProvider crmUrlProvider(@Value("${crm.host}") String crmHost) {
        return new CrmUrlProvider(crmHost, false);
    }

    @Bean
    public CrmUrlProvider crmLiteUrlProvider(@Value("${crm.host}") String crmHost) {
        return new CrmUrlProvider(crmHost, true);
    }

    @Bean
    public ProcuUrlProvider procuUrlProvider(@Value("${procu.host}") String procuHost) {
        return new ProcuUrlProvider(procuHost);
    }

    @Bean
    public RealHttpUrlProvider realHttpUrlProvider() {
        return new RealHttpUrlProvider(false);
    }

    @Bean
    public RealHttpUrlProvider realHttpsUrlProvider() {
        return new RealHttpUrlProvider(true);
    }

    @Bean
    public FemidaUrlProvider femidakUrlProvider(
            @Value("${femida.host}") String femidaHost)
    {
        return new FemidaUrlProvider(femidaHost);
    }

    @Bean
    public YaBroUrlProvider yaBroUrlProvider(
            @Value("${browser.mds.namespace}") String namespace,
            @Value("${mds.host-port}") HostPort mdsHostPort)
    {
        return new YaBroUrlProvider(namespace, mdsHostPort);
    }

    @Bean
    public TrackerUrlProvider trackerUrlProvider(@Value("${tracker_api.host}") String trackerApiHost) {
        return new TrackerUrlProvider(trackerApiHost);
    }

    @Bean
    public UslugiUrlProvider uslugiUrlProvider(@Value("${uslugi_api.host}") String uslugiApiHost) {
        return new UslugiUrlProvider(uslugiApiHost);
    }

    @Bean
    public SchoolbookUrlProvider schoolbookUrlProvider(@Value("${schoolbook_api.host}") String schoolbookApiHost) {
        return new SchoolbookUrlProvider(schoolbookApiHost);
    }

    @Bean
    public PracticumUrlProvider practicumUrlProvider(@Value("${practicum_api.host}") String practicumApiHost) {
        return new PracticumUrlProvider(practicumApiHost);
    }
}
