package ru.yandex.chemodan.app.docviewer.config.admin;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

import ru.yandex.chemodan.http.DiskJetty;
import ru.yandex.commune.admin.web.Admin;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author akirakozov
 */
public class AdminDaemonContextConfiguation {

    @Value("${admin.jetty.http.port}")
    private int adminJettyPort;

    @Bean
    @Admin
    public SingleWarJetty adminJetty()
    {
        SingleWarJetty singleWarJetty = new DiskJetty("dv-admin");
        singleWarJetty.setHttpPort(adminJettyPort);
        return singleWarJetty;
    }

}
