package ru.yandex.chemodan.app.docviewer.config.admin;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.docviewer.adapters.mongo.MongoDbAdapter;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.admin.web.AdminGroups;
import ru.yandex.commune.mongo.admin.explorer.MongoExplorerAdminPage;
import ru.yandex.commune.mongo.admin.schema.MongoSchemaAdminPage;
import ru.yandex.commune.mongo.schema.MongoSchemaChecker;
import ru.yandex.commune.mongo.schema.MongoSchemaCheckerContextConfiguration;

/**
 * @author akirakozov
 */
@Configuration
@Import({MongoSchemaCheckerContextConfiguration.class,
        MongoAdminDbAdapterConfiguration.class
})
public class DvMongoAdminContextConfiguration {
    @Autowired
    private AdminApp adminApp;
    @Autowired
    private MongoSchemaChecker mongoSchemaChecker;
    @Autowired
    @Qualifier("mongoAdminDbAdapter")
    private MongoDbAdapter mongoAdminDbAdapter;

    @PostConstruct
    public void configure() {
        adminApp.registerAdminPage("MongoDB schema checker",
                AdminGroups.DB, new MongoSchemaAdminPage(mongoSchemaChecker));
        adminApp.registerAdminPage("MongoDB explore", AdminGroups.DB, mongoExplorerAdminPage());
    }


    private MongoExplorerAdminPage mongoExplorerAdminPage() {
        MongoExplorerAdminPage adminPage = new MongoExplorerAdminPage();
        adminPage.addInstance("docviewer", mongoAdminDbAdapter.getMongo());
        return adminPage;
    }
}
