package ru.yandex.chemodan.app.docviewer.config.admin;

import com.mongodb.MongoClientOptions;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.docviewer.adapters.mongo.MongoDbAdapter;

/**
 * @author akirakozov
 */
@Configuration
public class MongoAdminDbAdapterConfiguration {

    @Bean
    public MongoDbAdapter mongoAdminDbAdapter(
            @Value("${mongodb.admin.user}") String user,
            @Value("${mongodb.admin.password}") String password,
            @Value("${mongodb.hosts}") String hosts,
            @Value("${mongodb.db}") String db,
            @Value("${mongodb.db.write.concern}") String dbWriteConcern,
            MongoClientOptions mongoClientOptions)
    {
        return new MongoDbAdapter(
                user, password, hosts, db, dbWriteConcern, mongoClientOptions);
    }

}
