package ru.yandex.chemodan.app.docviewer.config.conditions;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import ru.yandex.misc.property.PropertiesHolder;

public abstract class OnEnabledPropertyCondition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return PropertiesHolder.properties().getOrDefault(getPropertyName(), "false").equals("true");
    }

    abstract protected String getPropertyName();
}
