package ru.yandex.chemodan.app.docviewer.config.web;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.docviewer.MimeTypesHelper;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.copy.UriHelper;
import ru.yandex.chemodan.app.docviewer.disk.DiskManager;
import ru.yandex.chemodan.app.docviewer.states.StateMachine;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfHelper;
import ru.yandex.chemodan.app.docviewer.web.backend.ArchiveListingAction;
import ru.yandex.chemodan.app.docviewer.web.backend.ConvertToMsOoxmlAction;
import ru.yandex.chemodan.app.docviewer.web.backend.DownloadUrlAction;
import ru.yandex.chemodan.app.docviewer.web.backend.ExtractTextAction;
import ru.yandex.chemodan.app.docviewer.web.backend.FileInfoAction;
import ru.yandex.chemodan.app.docviewer.web.backend.GetOfficeRedactorUrlAction;
import ru.yandex.chemodan.app.docviewer.web.backend.GetPropertiesAction;
import ru.yandex.chemodan.app.docviewer.web.backend.GetPublicSettingsAction;
import ru.yandex.chemodan.app.docviewer.web.backend.HtmlImageAction;
import ru.yandex.chemodan.app.docviewer.web.backend.HtmlInfoAction;
import ru.yandex.chemodan.app.docviewer.web.backend.HtmlOnlyInfoAction;
import ru.yandex.chemodan.app.docviewer.web.backend.HtmlOnlyPageInfoAction;
import ru.yandex.chemodan.app.docviewer.web.backend.HtmlPageInfoAction;
import ru.yandex.chemodan.app.docviewer.web.backend.HtmlWithImagesBackendAction;
import ru.yandex.chemodan.app.docviewer.web.backend.HtmlWithImagesInfoAction;
import ru.yandex.chemodan.app.docviewer.web.backend.HtmlWithImagesPageInfoAction;
import ru.yandex.chemodan.app.docviewer.web.backend.MpfsOperationStatusAction;
import ru.yandex.chemodan.app.docviewer.web.backend.PdfBackendAction;
import ru.yandex.chemodan.app.docviewer.web.backend.PdfPageImageAction;
import ru.yandex.chemodan.app.docviewer.web.backend.PdfPageInfoAction;
import ru.yandex.chemodan.app.docviewer.web.backend.Post2Action;
import ru.yandex.chemodan.app.docviewer.web.backend.Post2HtmlAction;
import ru.yandex.chemodan.app.docviewer.web.backend.Post2IdAction;
import ru.yandex.chemodan.app.docviewer.web.backend.Post2PdfAction;
import ru.yandex.chemodan.app.docviewer.web.backend.Post2TextAction;
import ru.yandex.chemodan.app.docviewer.web.backend.PrerenderHtmlImageAction;
import ru.yandex.chemodan.app.docviewer.web.backend.PreviewAction;
import ru.yandex.chemodan.app.docviewer.web.backend.PreviewUrlAction;
import ru.yandex.chemodan.app.docviewer.web.backend.PublishStatusAction;
import ru.yandex.chemodan.app.docviewer.web.backend.RateLimiter;
import ru.yandex.chemodan.app.docviewer.web.backend.RenderImageAction;
import ru.yandex.chemodan.app.docviewer.web.backend.ResultAction;
import ru.yandex.chemodan.app.docviewer.web.backend.SaveFileFromArchiveAction;
import ru.yandex.chemodan.app.docviewer.web.backend.SavePropertyAction;
import ru.yandex.chemodan.app.docviewer.web.backend.SaveToDiskAction;
import ru.yandex.chemodan.app.docviewer.web.backend.SessionWriteAction;
import ru.yandex.chemodan.app.docviewer.web.backend.ShareAction;
import ru.yandex.chemodan.app.docviewer.web.backend.SourceAction;
import ru.yandex.chemodan.app.docviewer.web.backend.SourceInternalAction;
import ru.yandex.chemodan.app.docviewer.web.backend.StartAction;
import ru.yandex.chemodan.app.docviewer.web.backend.StartInternalAction;
import ru.yandex.chemodan.app.docviewer.web.backend.SupportedPreviewMimeTypesAction;
import ru.yandex.chemodan.app.docviewer.web.backend.TextAction;
import ru.yandex.chemodan.app.docviewer.web.backend.Url2IdAction;
import ru.yandex.chemodan.app.docviewer.web.backend.Url2ResultAction;
import ru.yandex.chemodan.app.docviewer.web.backend.UrlInfoAction;
import ru.yandex.chemodan.app.docviewer.web.framework.PingServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.PreviewHistoryManager;
import ru.yandex.chemodan.mpfs.MpfsClientContextConfiguration;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.thread.ParallelStreamSupplier;

/**
 * @author akirakozov
 */
@Configuration
@Import({MpfsClientContextConfiguration.class})
public class BackendContextConfiguration {

    @Bean
    public RateLimiter rateLimiter() {
        return new RateLimiter();
    }

    @Bean
    public PrerenderHtmlImageAction prerenderHtmlImageAction(PdfHelper pdfHelper) {
        return new PrerenderHtmlImageAction(pdfHelper);
    }

    @Bean
    public FileInfoAction fileInfoAction() {
        return new FileInfoAction();
    }

    @Bean
    public HtmlInfoAction htmlInfoAction() {
        return new HtmlOnlyInfoAction();
    }

    @Bean
    public HtmlInfoAction htmlWithImagesInfoAction() {
        return new HtmlWithImagesInfoAction();
    }

    @Bean
    public HtmlPageInfoAction htmlPageInfoAction() {
        return new HtmlOnlyPageInfoAction();
    }

    @Bean
    public HtmlPageInfoAction htmlWithImagesPageInfoAction() {
        return new HtmlWithImagesPageInfoAction();
    }

    @Bean
    public ResultAction htmlWithImagesBackendAction() {
        return new HtmlWithImagesBackendAction();
    }

    @Bean
    public ResultAction pdfBackendAction() {
        return new PdfBackendAction();
    }

    @Bean
    public ResultAction textAction() {
        return new TextAction();
    }

    @Bean
    public PdfPageInfoAction pdfPageInfoAction() {
        return new PdfPageInfoAction();
    }

    @Bean
    public PdfPageImageAction pdfPageImageBackendAction() {
        return new PdfPageImageAction();
    }

    @Bean
    public PingServlet pingServletBackend() {
        return new PingServlet();
    }

    @Bean
    public PingServlet pingSlbServletBackend() {
        return new PingServlet(true);
    }

    @Bean
    public Post2Action post2HtmlAction() {
        return new Post2HtmlAction();
    }

    @Bean
    public Post2Action post2PdfAction() {
        return new Post2PdfAction();
    }

    @Bean
    public Post2Action post2TextAction() {
        return new Post2TextAction();
    }

    @Bean
    public PreviewAction previewAction() {
        return new PreviewAction();
    }

    @Bean
    ParallelStreamSupplier httpAsyncStreamRunner(
            @Value("${docviewer.batch.maxThreads}") int threadCount,
            @Value("${docviewer.batch.timeOut}") int reqTimeout)
    {
        return ParallelStreamSupplier.builder()
                .maxThreadCount(threadCount)
                .invocationTimeoutMs(reqTimeout)
                .threadNameFactory("batchExecutorServiceThread")
                .build();
    }

    @Bean
    public PreviewUrlAction previewUrlAction(DiskManager diskManager,
            UriHelper uriHelper,
            PreviewHistoryManager previewHistoryManager,
            StateMachine stateMachine,
            ParallelStreamSupplier supplier,
            PreviewAction previewAction)
    {
        return new PreviewUrlAction(diskManager, uriHelper, previewHistoryManager, stateMachine, supplier, previewAction);
    }

    @Bean
    public ConvertToMsOoxmlAction convertToMsOoxmlAction() {
        return new ConvertToMsOoxmlAction();
    }

    @Bean
    public StartAction startAction() {
        return new StartAction();
    }

    @Bean
    public StartInternalAction startInternalAction() {
        return new StartInternalAction();
    }

    @Bean
    public Post2IdAction post2IdAction() {
        return new Post2IdAction();
    }

    @Bean
    public Url2IdAction url2IdAction() {
        return new Url2IdAction();
    }

    @Bean
    public Url2ResultAction url2ResultAction() {
        return new Url2ResultAction();
    }

    @Bean
    public UrlInfoAction urlInfoAction() {
        return new UrlInfoAction();
    }

    @Bean
    public DownloadUrlAction downloadUrlAction() {
        return new DownloadUrlAction();
    }

    @Bean
    public SaveToDiskAction saveToDiskAction() {
        return new SaveToDiskAction();
    }

    @Bean
    public ShareAction shareAction() {
        return new ShareAction();
    }

    @Bean
    public PublishStatusAction publishStatusAction() {
        return new PublishStatusAction();
    }

    @Bean
    public SaveFileFromArchiveAction saveFileFromArchiveAction() {
        return new SaveFileFromArchiveAction();
    }

    @Bean
    public MpfsOperationStatusAction mpfsOperationStatusAction() {
        return new MpfsOperationStatusAction();
    }

    @Bean
    public SourceAction sourceAction() {
        return new SourceAction();
    }

    @Bean
    public SourceInternalAction sourceInternalAction() {
        return new SourceInternalAction();
    }

    @Bean
    public HtmlImageAction htmlImageAction(@Value("${docviewer.image.remote-render}") boolean remoteRender) {
        return new HtmlImageAction(remoteRender);
    }

    @Bean
    public RenderImageAction renderImageAction() {
        return new RenderImageAction();
    }

    @Bean
    public ArchiveListingAction archiveListingAction() {
        return new ArchiveListingAction();
    }

    @Bean
    public SessionWriteAction sessionWriteAction() {
        return new SessionWriteAction();
    }

    @Bean
    public ExtractTextAction extractTextAction() {
        return new ExtractTextAction();
    }

    @Bean
    public SupportedPreviewMimeTypesAction supportedPreviewMimeTypesAction(ConvertManager manager, @Value("${copier.maxFileLength}") DataSize ds) {
        return new SupportedPreviewMimeTypesAction(manager.getPreviewMimeTypes(MimeTypesHelper.getAllMimeTypes()), ds);
    }

    @Bean
    public SavePropertyAction savePropertyAction() {
        return new SavePropertyAction();
    }

    @Bean
    public GetPropertiesAction getPropertiesAction() {
        return new GetPropertiesAction();
    }

    @Bean
    public GetOfficeRedactorUrlAction getOfficeRedactorUrlAction() {
        return new GetOfficeRedactorUrlAction();
    }

    @Bean
    public GetPublicSettingsAction getPublicSettingsAction() {
        return new GetPublicSettingsAction();
    }
}
