package ru.yandex.chemodan.app.docviewer.config.web;

import java.util.List;

import javax.servlet.Servlet;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.docviewer.web.backend.BackendServlet;
import ru.yandex.chemodan.http.DiskJetty;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;
import ru.yandex.misc.web.servletContainer.jetty.MuteErrorHandler;

/**
 * @author akirakozov
 */
@Configuration
public class BackendDaemonContextConfiguration {

    @Autowired
    private List<BackendServlet> actions;

    @Bean
    public SingleWarJetty backendJetty(
            @Value("${http.backend.maxThreads}")     int maxThreads,
            @Value("${http.backend.maxQueueLength}") int maxQueueLength,
            @Value("${http.backend.port}") int httpPort,
            @Value("${http.backend.maxIdleTime}") Duration maxIdleTime,
            Servlet pingServletBackend,
            Servlet pingSlbServletBackend)
    {
        SingleWarJetty jetty = new DiskJetty("dv");
        jetty.setHttpPort(httpPort);
        jetty.setMaxThreads(maxThreads);
        jetty.setMaxQueueLength(maxQueueLength);
        jetty.setRequestLogFactory(DiskLog4jRequestLog::new);
        jetty.setLookupServletsInContext(false);
        jetty.setRequestHeaderSizeO(12288);
        jetty.setMaxIdleTimeMillis((int) maxIdleTime.getMillis());

        for (BackendServlet action : actions) {
            jetty.addServletMapping(action.getActionUrl(), action);
        }

        jetty.addServletMapping("/ping", pingServletBackend);
        jetty.addServletMapping("/ping-slb", pingSlbServletBackend);

        jetty.initialize();
        jetty.getContainerRootContext().setErrorHandler(new MuteErrorHandler());

        return jetty;
    }
}
