package ru.yandex.chemodan.app.docviewer.config.web;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.docviewer.web.framework.PingServlet;
import ru.yandex.chemodan.app.docviewer.web.service.CleanupCacheAction;
import ru.yandex.chemodan.app.docviewer.web.service.CleanupHourAction;
import ru.yandex.chemodan.app.docviewer.web.service.CleanupPdfImageCacheAction;
import ru.yandex.chemodan.app.docviewer.web.service.CleanupUidAction;
import ru.yandex.chemodan.app.docviewer.web.service.CleanupUriAction;
import ru.yandex.chemodan.app.docviewer.web.service.FixStoredResults;
import ru.yandex.chemodan.app.docviewer.web.service.InfoAction;
import ru.yandex.chemodan.app.docviewer.web.service.RemoveAllAction;
import ru.yandex.chemodan.app.docviewer.web.service.RemoveResultsAction;
import ru.yandex.chemodan.app.docviewer.web.service.RemoveUrisAction;
import ru.yandex.commune.monitoring.SensorServlet;
import ru.yandex.misc.jvm.ThreadsServlet;
import ru.yandex.misc.property.web.PropertiesServlet;

/**
 * @author akirakozov
 */
@Configuration
public class ServiceContextConfiguration {

    @Bean
    public PingServlet pingServlet() {
        return new PingServlet();
    }

    @Bean
    public ThreadsServlet threadsServlet() {
        return new ThreadsServlet();
    }

    @Bean
    public SensorServlet sensorServlet() {
        return new SensorServlet();
    }

    @Bean
    public PropertiesServlet propertiesServlet() {
        return new PropertiesServlet();
    }

    @Bean
    public CleanupHourAction cleanupHourAction() {
        return new CleanupHourAction();
    }

    @Bean
    public CleanupCacheAction cleanupCacheAction() {
        return new CleanupCacheAction();
    }

    @Bean
    public RemoveAllAction removeAllAction() {
        return new RemoveAllAction();
    }

    @Bean
    public FixStoredResults fixStoredResults() {
        return new FixStoredResults();
    }

    @Bean
    public RemoveUrisAction removeUrisAction() {
        return new RemoveUrisAction();
    }

    @Bean
    public RemoveResultsAction removeResultsAction() {
        return new RemoveResultsAction();
    }

    @Bean
    public CleanupPdfImageCacheAction cleanupPdfImageCacheAction() {
        return new CleanupPdfImageCacheAction();
    }

    @Bean
    public CleanupUriAction cleanupUriAction() {
        return new CleanupUriAction();
    }

    @Bean
    public CleanupUidAction cleanupUidAction() {
        return new CleanupUidAction();
    }

    @Bean
    public InfoAction infoAction() {
        return new InfoAction();
    }

}
