package ru.yandex.chemodan.app.docviewer.config.web;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.docviewer.web.service.ServiceServlet;
import ru.yandex.chemodan.http.DiskJetty;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author akirakozov
 */
@Configuration
public class ServiceDaemonContextConfiguration {

    @Autowired
    private List<ServiceServlet> actions;

    @Bean
    public SingleWarJetty serviceJetty(
            @Value("${http.service.maxThreads}")     int maxThreads,
            @Value("${http.service.maxQueueLength}") int maxQueueLength,
            @Value("${http.service.port}") int httpPort,
            ServiceContextConfiguration conf)
    {
        SingleWarJetty jetty = new DiskJetty("dv");
        jetty.setHttpPort(httpPort);
        jetty.setMaxThreads(maxThreads);
        jetty.setMaxQueueLength(maxQueueLength);
        jetty.setRequestLogFactory(DiskLog4jRequestLog::new);
        jetty.setLookupServletsInContext(false);
        jetty.setRequestHeaderSizeO(8192);

        for (ServiceServlet action : actions) {
            jetty.addServletMapping(action.getActionUrl(), action);
        }

        jetty.addServletMapping("/ping", conf.pingServlet());
        jetty.addServletMapping("/sensor/*", conf.sensorServlet());
        jetty.addServletMapping("/threads", conf.threadsServlet());
        jetty.addServletMapping("/properties", conf.propertiesServlet());

        return jetty;
    }

}
