package ru.yandex.chemodan.app.docviewer.convert;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultInfo;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.thread.ThreadLocalTimeout;

/**
 * @author ssytnik
 */
public abstract class AbstractConverter implements Converter {

    @Override
    public ConvertResultInfo convert(
            InputStreamSource input, String contentType,
            TargetType convertTargetType, OutputStreamSource result,
            Option<String> password)
    {
        Validate.isTrue(isSupported(convertTargetType));
        ThreadLocalTimeout.check();

        return doConvert(input, contentType, convertTargetType, result, password);
    }

    protected abstract ConvertResultInfo doConvert(
            InputStreamSource input, String contentType,
            TargetType convertTargetType, OutputStreamSource result,
            Option<String> password);

}
