package ru.yandex.chemodan.app.docviewer.convert;

import lombok.Builder;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.log.StartConversionInfo;
import ru.yandex.chemodan.app.docviewer.states.ErrorCode;
import ru.yandex.chemodan.app.docviewer.utils.FileCopy;

@Builder
@Data
public class ConvertArgs {

    private final String fileId;
    private final TargetType targetType;
    private final String contentType;
    private final FileCopy localCopy;
    private final float priority;
    private final String sessionId;
    private final int failedAttemptsCount;
    private final StartConversionInfo startInfo;
    private final Instant lastTry;
    private final Instant startTime = Instant.now();
    private final String restoreUri;
    private final Option<ErrorCode> errorCode;
}

