package ru.yandex.chemodan.app.docviewer.convert;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultInfo;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.OutputStreamSource;

/**
 * @author vlsergey
 * @author ssytnik
 */
public interface Converter {

    ConvertResultInfo convert(InputStreamSource input, String contentType,
            TargetType convertTargetType, OutputStreamSource result,
            Option<String> password);

    default ConvertResultInfo convert(InputStreamSource input, String contentType,
          TargetType convertTargetType, OutputStreamSource result)
    {
        return convert(input, contentType, convertTargetType, result, Option.empty());
    }

    boolean isSupported(TargetType convertTargetType);

}
