package ru.yandex.chemodan.app.docviewer.convert;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;

import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultInfo;

/**
 * @author vpronto
 */
public abstract class CustomTimedAbstractConverter extends AbstractConverter implements AutoCloseable {


    private final ExecutorService executorTimeout = Executors.newFixedThreadPool(64);
    private final TimeLimiter timeLimiter = SimpleTimeLimiter.create(executorTimeout);

    private final long timeOutSeconds;

    public CustomTimedAbstractConverter(long timeOutSeconds) {
        this.timeOutSeconds = timeOutSeconds;
    }

    public CustomTimedAbstractConverter() {
        this(60);
    }

    protected ConvertResultInfo callWithTimeout(Callable<ConvertResultInfo> resultInfoCallable) throws Exception {
        return timeLimiter.callWithTimeout(resultInfoCallable, timeOutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        executorTimeout.shutdown();
    }

}
