package ru.yandex.chemodan.app.docviewer.convert;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.utils.XmlUtils2;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author ssytnik
 */
@Data
@Bendable
public final class DocumentProperties {

    public static final BenderJsonParser<DocumentProperties> P = Bender.parser(DocumentProperties.class);
    public static final BenderSerializer<DocumentProperties> S = Bender.serializer(DocumentProperties.class);

    public static final String AUTHOR = "author";
    public static final String CREATOR = "creator";
    public static final String COMMENTS = "comments";
    public static final String KEYWORDS = "keywords";
    public static final String SUBJECT = "subject";
    public static final String TITLE = "title";
    public static final String EXTRACTED_TEXT = "extracted_text";

    public static final DocumentProperties EMPTY = new DocumentProperties();

    @BenderPart
    private final MapF<String, String> properties;

    private DocumentProperties() {
        this(Cf.map());
    }

    public DocumentProperties(MapF<String, String> properties) {
        this.properties = properties;
    }

    public DocumentProperties withProperty(String name, String value) {
        String safeValue = XmlUtils2.stripInvalidXmlCharacters(value);
        return StringUtils.isEmpty(safeValue) ? this :
                new DocumentProperties(properties.plus1(name, safeValue));
    }

    public DocumentProperties withProperties(DocumentProperties other) {
        return other.properties.isEmpty() ? this :
                new DocumentProperties(properties.plus(other.properties));
    }

    public MapF<String, String> get() {
        return properties;
    }

    public Option<String> getO(String key) {
        return properties.getO(key);
    }

}
