package ru.yandex.chemodan.app.docviewer.convert;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultInfo;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.OutputStreamSource;

/**
 * @author ssytnik
 */
public class ImageToHtmlWrapper extends AbstractConverter {

    private final ImageConverter delegate;

    public ImageToHtmlWrapper(ImageConverter delegate) {
        super();
        this.delegate = delegate;
        validateDelegate();
    }

    private void validateDelegate() {
        if (delegate == null) {
            throw new IllegalStateException("Delegate is not set");
        }
        if (!delegate.isSupported(TargetType.HTML_WITH_IMAGES) || !delegate.isSupported(TargetType.HTML_WITH_IMAGES_FOR_MOBILE))
        {
            throw new IllegalStateException("Delegate '" + delegate + "' MUST support converting to HTML_WITH_IMAGES*");
        }
    }

    @Override
    public ConvertResultInfo doConvert(InputStreamSource input, String contentType,
            TargetType convertTargetType, OutputStreamSource result, Option<String> password)
    {
        return delegate.convert(input, contentType, convertTargetType, result, password);
    }

    @Override
    public boolean isSupported(TargetType convertTargetType) {
        return convertTargetType.isHtmlWithImages();
    }

    public String getDelegateName() {
        return delegate.getClass().getSimpleName();
    }

    @Override
    public String toString() {
        return getClass().getName() + "[" + delegate + "]";
    }

}
