package ru.yandex.chemodan.app.docviewer.convert;

import ru.yandex.misc.enums.EnumResolver;

public enum TargetType {
    HTML_ONLY,
    HTML_WITH_IMAGES,
    HTML_WITH_IMAGES_FOR_MOBILE,
    PDF,
    PREVIEW,
    // TODO: remove PDF_FIRST_PAGE after migration
    PDF_FIRST_PAGE,
    PLAIN_TEXT,
    MICROSOFT_OOXML_OFFICE,
    ;


    public boolean isHtml() {
        return this == HTML_ONLY || this == HTML_WITH_IMAGES || this == HTML_WITH_IMAGES_FOR_MOBILE;
    }

    public boolean isHtmlWithImages() {
        return this == HTML_WITH_IMAGES || this == HTML_WITH_IMAGES_FOR_MOBILE;
    }


    private static final EnumResolver<TargetType> resolver = new EnumResolver<>(
            TargetType.class);

    public static EnumResolver<TargetType> getResolver() {
        return resolver;
    }

    public static TargetType valueOf(String str, TargetType getOrElse) {
        return resolver.valueOfO(str).getOrElse(getOrElse);
    }
}
