package ru.yandex.chemodan.app.docviewer.convert.coreldraw;

import java.util.zip.ZipEntry;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.AbstractImageConverter;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultInfo;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.chemodan.app.docviewer.utils.ZipEntryInputStreamSource;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.OutputStreamSource;

// Actually converts compressed corel draw files
// TODO support fallback to cdr contents, if found within archive
/**
 * @author vlsergey
 * @author ssytnik
 */
public class CorelDrawConverter extends AbstractImageConverter {

    @Override
    public ConvertResultInfo doConvert(final InputStreamSource input, final String contentType,
            final TargetType convertTargetType, final OutputStreamSource result,
            final Option<String> password)
    {
        return FileUtils.withZipFile(input, zipFile -> {
            final ZipEntry zipEntry = zipFile.getEntry("metadata/thumbnails/thumbnail.bmp");
            if (zipEntry == null) {
                throw new RuntimeException(
                        "Unable to convert CorelDraw X5: no thumbnail.bmp in metadata");
            }

            final ZipEntryInputStreamSource inputImage = new ZipEntryInputStreamSource(zipFile,
                    zipEntry);

            return convertImage(inputImage, contentType, convertTargetType, result, password);
        });
    }

}
