package ru.yandex.chemodan.app.docviewer.convert.doc;

import java.util.Arrays;

final class ByteArrayHolder {

    private final byte[] bs;
    private final int hashCode;

    public ByteArrayHolder(final byte[] bs) {
        this.bs = bs;
        this.hashCode = Arrays.hashCode(bs);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ByteArrayHolder other = (ByteArrayHolder) obj;
        if (hashCode != other.hashCode)
            return false;
        if (!Arrays.equals(bs, other.bs))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        return hashCode;
    }

}
