package ru.yandex.chemodan.app.docviewer.convert.doc;

import java.util.concurrent.Callable;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.utils.scheduler.PrioritizedFutureTask;
import ru.yandex.chemodan.app.docviewer.utils.scheduler.Scheduler;

/**
 * @author akirakozov
 */
public class DocImageConvertManager {

    @Autowired
    private Scheduler convertDocImageScheduler;

    public <T> PrioritizedFutureTask<String, T> startImageConversion(
            final String taskKey, final Callable<T> task, float priority)
    {
        return convertDocImageScheduler.scheduleLocalTask(taskKey, task, priority);
    }

}
