package ru.yandex.chemodan.app.docviewer.convert.doc;

import org.apache.poi.hwpf.converter.DefaultFontReplacer;

import ru.yandex.misc.lang.StringUtils;

public class ExtendedFontReplacer extends DefaultFontReplacer {

    @Override
    public Triplet update(Triplet original) {
        Triplet updated = super.update(original);

        if (!StringUtils.isEmpty(updated.fontName)) {
            if (updated.fontName.equals("PragmaticaWINCTT")) {
                updated.fontName = "Liberation Sans";
            }

            if (updated.fontName.equals("Tahoma")) {
                updated.fontName = "DejaVu Sans";
            }

            if (updated.fontName.equals("Times") || updated.fontName.equals("Times New Roman")) {
                updated.fontName = "Liberation Serif";
            }
        }

        return updated;
    }
}
