package ru.yandex.chemodan.app.docviewer.convert.doc;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import fr.opensagres.odfdom.converter.pdf.PdfConverter;
import fr.opensagres.odfdom.converter.pdf.PdfOptions;
import fr.opensagres.odfdom.converter.xhtml.XHTMLConverter;
import fr.opensagres.odfdom.converter.xhtml.XHTMLOptions;
import org.odftoolkit.odfdom.doc.OdfDocument;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.CustomTimedAbstractConverter;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultInfo;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultType;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.chemodan.app.docviewer.utils.XmlUtils2;
import ru.yandex.chemodan.app.docviewer.utils.html.ConvertToHtmlHelper;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.io.file.File2;

public class OdfConverter extends CustomTimedAbstractConverter {

    private final ConvertToHtmlHelper convertToHtmlHelper = new ConvertToHtmlHelper();

    @Override
    protected ConvertResultInfo doConvert(InputStreamSource input, String contentType, TargetType convertTargetType,
                OutputStreamSource result, Option<String> password)
    {
        try (InputStream doc = input.getInput();
             OutputStream out = result.getOutput();
        ) {
            return callWithTimeout(() -> {
                OdfDocument document = OdfDocument.loadDocument(doc);

                switch (convertTargetType) {
                    case PDF:
                    case PLAIN_TEXT:
                        PdfOptions options = PdfOptions.getDefault();
                        PdfConverter.getInstance().convert(document, out, options);
                        return ConvertResultInfo.builder().type(ConvertResultType.PDF).build();
                    case HTML_ONLY:
                        XHTMLOptions xhtmlOptions = null;
                        File2 tmp = null;
                        try {
                            tmp = FileUtils.createEmptyTempFile("convertresult", ".tmp");
                            XHTMLConverter.getInstance()
                                    .convert(document, new FileOutputStream(tmp.getFile()), xhtmlOptions);
                            int pages = convertToHtmlHelper.splitAndPack(
                                    XmlUtils2.parseHtmlToDom4j(tmp.asReaderSource()), result, false,
                                    Option.empty(), false);
                            return ConvertResultInfo.builder().type(ConvertResultType.ZIPPED_HTML).pages(pages).build();
                        }finally {
                            if(tmp != null){
                                tmp.deleteRecursiveQuietly();
                            }
                        }
                    default: {
                        throw new UnsupportedOperationException("NYI: " + convertTargetType);
                    }
                }
            });
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }

    @Override
    public boolean isSupported(TargetType convertTargetType) {
        return convertTargetType == TargetType.PDF;
    }
}
