package ru.yandex.chemodan.app.docviewer.convert.openoffice;

import java.util.Map;

import com.artofsolving.jodconverter.DefaultDocumentFormatRegistry;
import com.artofsolving.jodconverter.DocumentFamily;
import com.artofsolving.jodconverter.DocumentFormat;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.docviewer.MimeTypes;

/**
 * @author vlsergey
 * @author akirakozov
 */
public class ExtendedDocumentFormatRegistry extends DefaultDocumentFormatRegistry {

    private ExtendedDocumentFormatRegistry() {

        final DocumentFormat docx = new DocumentFormat("Microsoft OOXML Word", DocumentFamily.TEXT,
                MimeTypes.MIME_MICROSOFT_OOXML_WORD, "docx");
        docx.setExportFilter(DocumentFamily.TEXT, "MS Word 2007 XML");
        addDocumentFormat(docx);

        final DocumentFormat dotx = new DocumentFormat("Microsoft OOXML Word Template",
                DocumentFamily.TEXT, MimeTypes.MIME_MICROSOFT_OOXML_WORD_TEMPLATE, "dotx");
        addDocumentFormat(dotx);

        final DocumentFormat xlsx = new DocumentFormat("Microsoft OOXML Excel",
                DocumentFamily.SPREADSHEET, MimeTypes.MIME_MICROSOFT_OOXML_EXCEL, "xlsx");
        xlsx.setExportFilter(DocumentFamily.SPREADSHEET, "Calc MS Excel 2007 XML");
        addDocumentFormat(xlsx);

        final DocumentFormat xlsb = new DocumentFormat("Microsoft OOXML Excel",
                DocumentFamily.SPREADSHEET, MimeTypes.overrideExtensionMimeTypes.getTs(".xlsb").toLowerCase(), "xlsb");
        xlsb.setExportFilter(DocumentFamily.SPREADSHEET, "Calc MS Excel 2007 XML");
        addDocumentFormat(xlsb);

        final DocumentFormat xltx = new DocumentFormat("Microsoft OOXML Excel Template",
                DocumentFamily.SPREADSHEET, MimeTypes.MIME_MICROSOFT_OOXML_EXCEL_TEMPLATE, "xltx");
        addDocumentFormat(xltx);

        final DocumentFormat pptx = new DocumentFormat("Microsoft OOXML PowerPoint",
                DocumentFamily.PRESENTATION, MimeTypes.MIME_MICROSOFT_OOXML_POWERPOINT, "pptx");
        pptx.setExportFilter(DocumentFamily.PRESENTATION, "Impress MS PowerPoint 2007 XML");
        addDocumentFormat(pptx);

        final DocumentFormat potx = new DocumentFormat("Microsoft OOXML PowerPoint Template",
                DocumentFamily.PRESENTATION, MimeTypes.MIME_MICROSOFT_OOXML_POWERPOINT_TEMPLATE,
                "pptx");
        addDocumentFormat(potx);

        final DocumentFormat rtf = new DocumentFormat("Rich Text Format", DocumentFamily.TEXT,
                MimeTypes.MIME_RTF, "rtf");
        rtf.setExportFilter(DocumentFamily.TEXT, "Rich Text Format");
        addDocumentFormat(rtf);

        final DocumentFormat txt = new DocumentFormat("Plain Text", DocumentFamily.TEXT,
                MimeTypes.MIME_TEXT_PLAIN, "txt");

        txt.setImportOption("Hidden", "True");
        txt.setImportOption("FilterName", "Text");

        txt.setExportOption(DocumentFamily.TEXT, "Hidden", "True");
        txt.setExportFilter(DocumentFamily.TEXT, "Text (encoded)");
        txt.setExportOption(DocumentFamily.TEXT, "FilterOptions", "UTF-8");

        txt.setExportFilter(DocumentFamily.SPREADSHEET, "Text - txt - csv (StarCalc)");

        while (getFormatByMimeType(MimeTypes.MIME_TEXT_PLAIN) != null) {
            getDocumentFormats().remove(getFormatByMimeType(MimeTypes.MIME_TEXT_PLAIN));
        }

        addDocumentFormat(txt);

        final DocumentFormat wordml = new DocumentFormat("Microsoft Office Word 2003 XML Format",
                DocumentFamily.TEXT, MimeTypes.MIME_MICROSOFT_WORDML, "xml");
        wordml.setImportOption("FilterName", "MS Word 2003 XML");
        addDocumentFormat(wordml);

        final DocumentFormat spreadsheetml = new DocumentFormat(
                "Microsoft Office Excel 2002 and Excel 2003 XML Format",
                DocumentFamily.SPREADSHEET, MimeTypes.MIME_MICROSOFT_SPREADSHEETML, "xml");
        spreadsheetml.setImportOption("FilterName", "MS Excel 2003 XML");
        addDocumentFormat(spreadsheetml);
    }

    public final static ExtendedDocumentFormatRegistry INSTANCE = new ExtendedDocumentFormatRegistry();
    public final static ListF<DocumentFamily> FAMILIES = Cf.list(
            DocumentFamily.DRAWING,
            DocumentFamily.PRESENTATION,
            DocumentFamily.SPREADSHEET,
            DocumentFamily.TEXT);

    public static DocumentFormat exportFirstPdfPageFormat() {
        final DocumentFormat pdf = new DocumentFormat("Portable Document Format", "application/pdf", "pdf");

        pdf.setExportFilter(DocumentFamily.DRAWING, "draw_pdf_Export");
        pdf.setExportFilter(DocumentFamily.PRESENTATION, "impress_pdf_Export");
        pdf.setExportFilter(DocumentFamily.SPREADSHEET, "calc_pdf_Export");
        pdf.setExportFilter(DocumentFamily.TEXT, "writer_pdf_Export");

        Map<String, String> pdfOptions = Cf.map("PageRange", "1");
        for (DocumentFamily family : FAMILIES) {
            pdf.setExportOption(family, "FilterData", pdfOptions);
        }

        return pdf;
    }

}
