package ru.yandex.chemodan.app.docviewer.convert.openoffice;

import com.artofsolving.jodconverter.DocumentFormat;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.adapters.openoffice.ExtendedOpenOfficeConnection;
import ru.yandex.chemodan.app.docviewer.adapters.openoffice.OpenOfficeProcessPool;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.Stopwatch;

/**
 * @author akirakozov
 */
public class OldOfficeDocumentConverter {
    private static final Logger logger = LoggerFactory.getLogger(OldOfficeDocumentConverter.class);

    private static final ExtendedDocumentFormatRegistry formatRegistry = ExtendedDocumentFormatRegistry.INSTANCE;

    public void convert(File2 input, OpenOfficeProcessPool commonOOProcessPool) {
        ExtendedOpenOfficeConnection connection = commonOOProcessPool.openConnection(10);

        ExtendedOpenOfficeDocumentConverter converter =
                new ExtendedOpenOfficeDocumentConverter(
                        connection,
                        ExtendedDocumentFormatRegistry.INSTANCE,
                        Duration.standardSeconds(3),
                        Option.empty());

        String ext = input.getExtension();
        String outExt = ext + "x";
        DocumentFormat inFormat = formatRegistry.getFormatByFileExtension(ext);
        DocumentFormat outFormat = formatRegistry.getFormatByFileExtension(outExt);


        String path = input.getAbsolutePath();
        File2 output = new File2(StringUtils.substringBeforeLast(path, ".") + "." + outExt);
        Stopwatch stopwatch = Stopwatch.createAndStart();
        converter.convert(input.getFile(), inFormat, output.getFile(), outFormat);
        stopwatch.log("Conversion of " + input.getName(), logger);
    }
}
