package ru.yandex.chemodan.app.docviewer.convert.openoffice;

import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.app.docviewer.convert.TargetType;

/**
 * @author vlsergey
 * @author akirakozov
 */
public class PresentationConverter extends OpenOfficeConverter {

    @Value("${ppt.max.attempts}")
    private int maxAttemptsNumber;


    @Override
    protected int getMaxAttemptsNumber() {
        return maxAttemptsNumber;
    }

    @Override
    public boolean isSupported(TargetType convertTargetType) {
        if (convertTargetType == TargetType.PLAIN_TEXT) {
            return false;
        }
        return super.isSupported(convertTargetType);
    }

}
