package ru.yandex.chemodan.app.docviewer.convert.openoffice;

import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.uno.UnoRuntime;

import ru.yandex.misc.ExceptionUtils;

class StylesheetUtils {

    static void setPagePropertiesForStylesheet(XComponent xComponent) {
        try {
            XSpreadsheetDocument xSpreadsheetDocument = UnoRuntime.queryInterface(
                    XSpreadsheetDocument.class, xComponent);

            if (xSpreadsheetDocument == null)
                // exception?
                return;

            XStyleFamiliesSupplier xStyleFamiliesSupplier = UnoRuntime.queryInterface(
                    XStyleFamiliesSupplier.class, xComponent);

            Object objPageStyles = xStyleFamiliesSupplier.getStyleFamilies()
                    .getByName("PageStyles");
            XIndexAccess xIndexAccess = UnoRuntime
                    .queryInterface(XIndexAccess.class, objPageStyles);

            for (int pageStyleIndex = 0; pageStyleIndex < xIndexAccess.getCount(); pageStyleIndex++)
            {
                Object objDefaultStyle = xIndexAccess.getByIndex(pageStyleIndex);
                XPropertySet xStyle = UnoRuntime
                        .queryInterface(XPropertySet.class, objDefaultStyle);
                xStyle.setPropertyValue("IsLandscape", Boolean.TRUE);

                xStyle.setPropertyValue("HeaderOn", Boolean.FALSE);
                xStyle.setPropertyValue("FooterOn", Boolean.FALSE);

                xStyle.setPropertyValue("PrintGrid", Boolean.TRUE);

                Size size = (Size) xStyle.getPropertyValue("Size");

                int a = size.Height;
                int b = size.Width;

                size.Height = Math.min(a, b);
                size.Width = Math.max(a, b);
                xStyle.setPropertyValue("Size", size);

                xStyle.setPropertyValue("ScaleToPages", (short) 0);
                xStyle.setPropertyValue("ScaleToPagesX", (short) 1);
                xStyle.setPropertyValue("ScaleToPagesY", (short) 0);
            }
        } catch (Exception exc) {
            throw ExceptionUtils.translate(exc);
        }
    }

}
