package ru.yandex.chemodan.app.docviewer.convert.pdf;

import org.apache.pdfbox.pdmodel.graphics.color.PDColorState;
import org.apache.pdfbox.util.TextPosition;

public class ColoredTextPosition extends TextPositionWrapper {
    private final int textRenderingMode;
    private final PDColorState strokingColor;
    private final PDColorState nonStrokingColor;

    public ColoredTextPosition(TextPosition delegate, int textRenderingMode,
            PDColorState strokingColor, PDColorState nonStrokingColor)
    {
        super(delegate);
        this.textRenderingMode = textRenderingMode;
        this.strokingColor = strokingColor;
        this.nonStrokingColor = nonStrokingColor;
    }

    public int getTextRenderingMode() {
        return textRenderingMode;
    }

    public PDColorState getStrokingColor() {
        return strokingColor;
    }

    public PDColorState getNonStrokingColor() {
        return nonStrokingColor;
    }

}
