package ru.yandex.chemodan.app.docviewer.convert.pdf.fonts;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;

/**
 * Contains font css info to be put to output html.
 * This structure is created by {@link FontManager}.
 *
 * @author ssytnik
 */
@Data
@AllArgsConstructor
public class FontCss {
    private final String fontStyle;
    private final Option<Tuple2<String, String>> fontFaceIdAndStyleO;

    public FontCss(String fontStyle) {
        this(fontStyle, Option.empty());
    }

    public boolean hasFontFace() {
        return fontFaceIdAndStyleO.isPresent();
    }

    public String getFontFaceId() {
        return fontFaceIdAndStyleO.get().get1();
    }

    public String getFontFaceStyle() {
        return fontFaceIdAndStyleO.get().get2();
    }

}
