package ru.yandex.chemodan.app.docviewer.convert.pdf.fonts;

import java.util.EnumMap;

import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.Validate;

/**
 * A result of pdf font name parsing
 * @see FontNameParser
 *
 * @author ssytnik
 */
@Data
public class FontNameInfo {
    private final String fontFamily;
    private final String fontStyles;

    private final ListF<String> cssFamilies; // specific to common, not quoted
    private final EnumMap<CssFontStyleProperty, String> cssStyles;

    public FontNameInfo(
            String fontFamily, String fontStyles,
            ListF<String> cssFamilies, EnumMap<CssFontStyleProperty, String> cssStyles)
    {
        Validate.notNull(fontFamily);
        Validate.notNull(fontStyles);
        Validate.notNull(cssFamilies);
        //Validate.notEmpty(cssFamilies);
        Validate.notNull(cssStyles);;

        this.fontFamily = fontFamily;
        this.fontStyles = fontStyles;
        this.cssFamilies = cssFamilies;
        this.cssStyles = cssStyles;
    }

    @Override
    public String toString() {
        return String.format("Font name [%s], styles [%s], css families %s, css styles %s",
                fontFamily, fontStyles, cssFamilies, cssStyles);
    }

    public String getFontFamilyWithStyles() {
        return fontFamily + fontStyles;
    }

}
