package ru.yandex.chemodan.app.docviewer.convert.result;

import lombok.Builder;
import lombok.Data;
import lombok.NonNull;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.DocumentProperties;
import ru.yandex.chemodan.app.docviewer.utils.FileList;

/**
 * @author vpronto
 */
@Data
@Builder(toBuilder = true)
public class ConvertResultInfo {
    @NonNull private final ConvertResultType type;
    @Builder.Default private final int pages = 1;
    @Builder.Default private final Option<PagesInfo> pagesInfo = Option.empty();
    @Builder.Default private final DocumentProperties properties = DocumentProperties.EMPTY;
    @Builder.Default private final Option<FileList> images = Option.empty();

    public boolean isPdf() {
        return type == ConvertResultType.PDF;
    }

    public boolean isZippedHtml() {
        return type == ConvertResultType.ZIPPED_HTML;
    }

    public ConvertResultInfo withPropertiesAdded(DocumentProperties other) {
        return this.toBuilder().properties(other).build();
    }
}
