package ru.yandex.chemodan.app.docviewer.convert.result;

import ru.yandex.misc.enums.EnumResolver;

/**
 * @author ssytnik
 */
public enum ConvertResultType {
    ZIPPED_HTML("zip"),
    PDF("pdf"),
    PLAIN_TEXT("txt"),
    ARCHIVE_LISTING("xml"),
    MICROSOFT_OOXML_WORD("docx"),
    MICROSOFT_OOXML_EXCEL("xlsx"),
    MICROSOFT_OOXML_POWERPOINT("pptx"),
    ;

    private final String extension;

    ConvertResultType(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return extension;
    }


    private static EnumResolver<ConvertResultType> resolver =
            new EnumResolver<>(ConvertResultType.class);

    public static EnumResolver<ConvertResultType> getResolver() {
        return resolver;
    }
}
