package ru.yandex.chemodan.app.docviewer.convert.result;

import lombok.Builder;
import lombok.Data;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author akirakozov
 */
@Data
@Builder(toBuilder = true)
public class ExConvertResultInfo {
    private final ConvertResultInfo resultInfo;
    private final File2 resultFile;
    private final String converterName;
    @Builder.Default private final Duration convertTime = Duration.ZERO;

    public ExConvertResultInfo withDuration(Instant startTime) {
       return this.toBuilder().convertTime(TimeUtils.toDurationToNow(startTime)).build();
    }
}
