package ru.yandex.chemodan.app.docviewer.convert.result;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.utils.DimensionO;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
@Data
@BenderBindAllFields
public class PageInfo {
    private final Option<Integer> index;
    private final Option<Float> height;
    private final Option<Float> width;

    @BenderIgnore
    private final Option<Boolean> rotated;

    public PageInfo(int index, float width, float height) {
        this(Option.of(index),
                Option.of(Math.abs(width)),
                Option.of(Math.abs(height)),
                Option.empty());
    }

    public PageInfo(int index, float width, float height, boolean rotated) {
        this(Option.of(index),
                Option.of(Math.abs(width)),
                Option.of(Math.abs(height)),
                Option.of(rotated));
    }

    public PageInfo(Option<Integer> index, Option<Float> width, Option<Float> height, Option<Boolean> rotated) {
        this.index = index;
        this.width = width.map(Math::abs);
        this.height = height.map(Math::abs);
        this.rotated = rotated;
    }

    public Dimension getBoundingBox(DimensionO size) {
        float compress = getCompress(size);

        int resWidth = Math.round(width.get() / compress);
        int resHeight = Math.round(height.get() / compress);

        return Dimension.valueOf(resWidth, resHeight);
    }

    private float getCompress(DimensionO size) {
        Validate.some(width);
        Validate.some(height);
        Validate.isTrue(size.hasWidthOrHeight());

        float compressWidth = size.width.isPresent() ? width.get() / size.width.get().floatValue() : 0;
        float compressHeight = size.height.isPresent() ? height.get() / size.height.get().floatValue() : 0;

        return Math.max(compressWidth, compressHeight);
    }
}
