package ru.yandex.chemodan.app.docviewer.convert.text;

import java.io.IOException;
import java.io.Reader;

import au.com.bytecode.opencsv.CSVReader;
import org.apache.poi.hwpf.converter.HtmlDocumentFacade;
import org.w3c.dom.Element;

import ru.yandex.chemodan.app.docviewer.utils.XmlUtils2;
import ru.yandex.misc.io.IoUtils;

/**
 * @author vlsergey
 */
public class CsvConverter extends TextConverterSupport {

    @Override
    protected void doConvertToHtml(Reader inputReader, HtmlDocumentFacade htmlDocumentFacade) throws IOException {
        CSVReader csvReader = null;
        try {
            csvReader = new CSVReader(inputReader);

            Element table = htmlDocumentFacade.createTable();
            Element tableBody = htmlDocumentFacade.createTableBody();

            String[] next = csvReader.readNext();
            while (next != null) {

                Element row = htmlDocumentFacade.createTableRow();
                for (String data : next) {
                    Element cell = htmlDocumentFacade.createTableCell();
                    cell.appendChild(htmlDocumentFacade.createText(XmlUtils2.stripInvalidXmlCharacters(data)));
                    row.appendChild(cell);
                }
                tableBody.appendChild(row);

                next = csvReader.readNext();
            }
            table.appendChild(tableBody);
            htmlDocumentFacade.getBody().appendChild(table);
        } finally {
            IoUtils.closeQuietly(csvReader);
        }
    }

}
