package ru.yandex.chemodan.app.docviewer.convert.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

import org.apache.poi.hwpf.converter.HtmlDocumentFacade;
import org.springframework.beans.factory.annotation.Value;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.chemodan.app.docviewer.utils.XmlUtils2;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author metal
 */
public class PgpConverter extends TextConverter {
    @Value("${pgp.max.file.size}")
    private DataSize pgpMaxSize;

    @Override
    protected void doConvertToHtml(Reader inputReader, HtmlDocumentFacade htmlDocumentFacade) throws IOException {
        BufferedReader textReader = new BufferedReader(inputReader);

        String next = textReader.readLine();
        StringBuilder pgpMessage = new StringBuilder(next);
        while (next != null) {
            next = textReader.readLine();
            if (StringUtils.isNotEmpty(next)) {
                if (pgpMessage.length() > pgpMaxSize.toBytes()) {
                    final File2 temporaryFile = FileUtils.createEmptyTempFile("pgp", ".asc");
                    try {
                        copyPgpMessageToTempFile(temporaryFile, pgpMessage.toString(), textReader);
                        super.doConvertToHtml(temporaryFile.asReaderSource().getInput(), htmlDocumentFacade);
                        return;
                    } finally {
                        temporaryFile.deleteRecursiveQuietly();
                    }
                }

                pgpMessage = pgpMessage.append("\n").append(next);
            }
        }

        Element div = htmlDocumentFacade.createBlock();
        Element pre = htmlDocumentFacade.getDocument().createElement("pre");
        div.appendChild(pre);
        pre.setTextContent(XmlUtils2.stripInvalidXmlCharacters(pgpMessage.toString()));
        htmlDocumentFacade.getBody().appendChild(div);
    }

    @Override
    protected int splitAndPackResult(OutputStreamSource result, Document document) {
        return convertToHtmlHelper.splitAndPack(
                XmlUtils2.convertToDom4j(document), result, false, Option.empty(), pgpMaxSize, pgpMaxSize);
    }

    private void copyPgpMessageToTempFile(File2 file, String read, BufferedReader remainsReader) throws IOException {
        OutputStreamSource pgpMessageOutput = file.asAppendOutputStreamTool();
        pgpMessageOutput.write(read);
        String next = remainsReader.readLine();
        while (next != null) {
            pgpMessageOutput.writeLine(next);
            next = remainsReader.readLine();
        }
    }
}
