package ru.yandex.chemodan.app.docviewer.convert.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

import org.apache.poi.hwpf.converter.HtmlDocumentFacade;
import org.w3c.dom.Element;

import ru.yandex.chemodan.app.docviewer.utils.XmlUtils2;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author ssytnik
 */
public class TextConverter extends TextConverterSupport {

    @Override
    protected void doConvertToHtml(Reader inputReader, HtmlDocumentFacade htmlDocumentFacade) throws IOException {
        BufferedReader textReader = new BufferedReader(inputReader);

        String next = textReader.readLine();
        while (next != null) {
            next = next.trim();
            if (StringUtils.isNotEmpty(next)) {
                Element p = htmlDocumentFacade.createParagraph();
                p.setTextContent(XmlUtils2.stripInvalidXmlCharacters(next));
                htmlDocumentFacade.addStyleClass(p, "mg", "margin: 0.75em 0");
                htmlDocumentFacade.getBody().appendChild(p);
            }

            next = textReader.readLine();
        }
    }

}
