package ru.yandex.chemodan.app.docviewer.convert.uniconvertor;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.adapters.uniconvertor.UniconvertorAdapter;
import ru.yandex.chemodan.app.docviewer.convert.AbstractConverter;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultInfo;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultType;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.io.file.FileOutputStreamSource;

/**
 * @author vlsergey
 */
public class UniconvertorConverter extends AbstractConverter {

    @Autowired
    private UniconvertorAdapter uniconvertorAdapter;

    @Override
    public ConvertResultInfo doConvert(final InputStreamSource input, String contentType,
            TargetType convertTargetType, final OutputStreamSource result,
            final Option<String> password)
    {
        FileUtils.withEmptyTemporaryFile("uniconvertor", ".pdf", tempPdfFile -> {
            uniconvertorAdapter.convert(input, new FileOutputStreamSource(tempPdfFile));
            tempPdfFile.readTo(result);
        });

        return ConvertResultInfo.builder().type(ConvertResultType.PDF).build();
    }

    @Override
    public boolean isSupported(TargetType convertTargetType) {
        return convertTargetType == TargetType.PDF;
    }

}
