package ru.yandex.chemodan.app.docviewer.convert.xls;

import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.InputStreamX;
import ru.yandex.misc.io.IoFunction;

public class XlsUtils {
    private static final Logger logger = LoggerFactory.getLogger(XlsUtils.class);

    public static boolean isSupported(HSSFWorkbook workbook) {
        try {
            return workbook.getAllPictures().isEmpty()
                    && workbook.getAllEmbeddedObjects().isEmpty();
        } catch (Exception exc) {
            logger.warn("Unable to check if XlsConverter can process workbook: " + exc);
            return false;
        }
    }

    public static boolean isSupported(InputStreamSource source, Option<String> password) {
        try {
            return isSupported(loadWorkbook(source, password));
        } catch (OldExcelFormatException exc) {
            return false;
        }
    }

    public static HSSFWorkbook loadWorkbook(InputStreamSource source, Option<String> password) {
        Biff8EncryptionKey.setCurrentUserPassword(password.getOrNull());
        try {
            // NOTE: Biff8EncryptionKey.setCurrentUserPassword(...) causes FopEntryPoint
            // to stop responding at /ping, even before document starts to be processed,
            // thus converting encrypted XLS to PDF does not work
            HSSFWorkbook workbook = source.readX((IoFunction<InputStreamX, HSSFWorkbook>) HSSFWorkbook::new);
            return workbook;
        } finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

}
