package ru.yandex.chemodan.app.docviewer.copy;

import java.net.URI;
import java.net.URL;

import com.yandex.ydb.table.values.PrimitiveValue;
import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.docviewer.utils.UriUtils;
import ru.yandex.chemodan.ydb.dao.YdbPrimitiveStringCompatible;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
@Data
@EqualsAndHashCode
public class ActualUri implements YdbPrimitiveStringCompatible {
    private final URI uri;

    public ActualUri(URI actualUri) {
        Validate.notNull(actualUri);
        this.uri = actualUri;
    }

    public ActualUri(String actualUri) {
        this.uri = UriUtils.toUri(actualUri);
    }

    public ActualUri(URL actualUrl) {
        this.uri = UriUtils.toUri(actualUrl);
    }

    public URI getUri() {
        return uri;
    }

    public String getUriString() {
        return UriUtils.toUriString(uri);
    }

    public Option<String> getArchivePathO() {
        return UrlUtils.getNotEmptyParameterFromUrl(getUriString(), "archive-path");
    }

    public ActualUri withoutArchivePath() {
        return new ActualUri(UrlUtils.removeParameter(getUriString(), "archive-path"));
    }

    public ActualUri withArchivePath(Option<String> archivePathO) {
        String uri = UrlUtils.removeParameter(getUriString(), "archive-path");
        if (archivePathO.isPresent()) {
            uri = UrlUtils.addParameter(uri, "archive-path", archivePathO.get());
        }
        return new ActualUri(uri);
    }

    public ActualUri withArchivePath(String archivePath) {
        return withArchivePath(StringUtils.notEmptyO(archivePath));
    }

    public static Function<String, ActualUri> consFromStringF() {
        return ActualUri::new;
    }


    @BenderTextValue
    public static ActualUri benderParse(String value) {
        return new ActualUri(value);
    }

    @BenderTextValue
    public String benderSerialize() {
        return getUriString();
    }

    @Override
    public PrimitiveValue getValue() {
        return PrimitiveValue.string(uri.toString().getBytes());
    }
}
