package ru.yandex.chemodan.app.docviewer.copy;

/**
 * @author ssytnik
 */
public enum CacheResult {
    HIT("hit"),
    MISS("miss"),
    N_A("n/a"),
    /**
     * used if one get a cache hit for a data for which cache is treated non-applicable
     */
    HIT_N_A("hit_n/a")
    ;

    private final String value;

    CacheResult(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static CacheResult get(boolean expectedIsApplicable, boolean actuallyFoundInCache) {
        return expectedIsApplicable ? (actuallyFoundInCache ? HIT : MISS) : (actuallyFoundInCache ? HIT_N_A : N_A);
    }
}
