package ru.yandex.chemodan.app.docviewer.copy;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.dao.results.StoredResult;
import ru.yandex.chemodan.app.docviewer.log.StartConversionInfo;

/**
 * @author akirakozov
 */
@Getter
@Builder
public class CopyInfo {
    public final ActualUri uri;
    public final boolean isExternalUri;
    public final Option<String> contentType;
    public final String sessionId;
    public final DocumentSourceInfo source;
    public final StartConversionInfo startInfo;
    public final boolean forwarded;
    public final Option<String> tvmUserTicket;

    public String createRestoreUri() {
        return StoredResult.createRestoreUri(uri, isExternalUri);
    }

    @Override
    public String toString() {
        return "CopyInfo{" +
                "uri=" + uri +
                ", isExternalUri=" + isExternalUri +
                ", contentType=" + contentType +
                ", sessionId='" + sessionId + '\'' +
                ", source=" + source +
                ", startInfo=" + startInfo +
                ", forwarded=" + forwarded +
                '}';
    }
}
