package ru.yandex.chemodan.app.docviewer.copy;

import lombok.Builder;
import lombok.Data;
import lombok.NonNull;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.web.backend.NdaUtils;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author akirakozov
 */
@Data
@Builder(toBuilder = true)
public class DocumentSourceInfo {
    @NonNull private final String originalUrl;
    @Builder.Default private final PassportUidOrZero uid = PassportUidOrZero.zero();
    @Builder.Default private final Option<String> archivePath = Option.empty();
    @Builder.Default private final Option<StorageResourceInfo> copierResponse = Option.empty();
    @Builder.Default private final boolean showNda = false;
    @Builder.Default private final boolean warmUp = false;
    @Builder.Default private final Option<String> remoteFileId = Option.empty();

    public DocumentSourceInfo withShowNda(boolean value) {
        return this.toBuilder().showNda(value).build();
    }

    public DocumentSourceInfo withShowNda(String nullableValue) {
        return withShowNda(NdaUtils.isShowNdaSet(nullableValue));
    }

}
