package ru.yandex.chemodan.app.docviewer.copy;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;

/**
 * @author metal
 */
public class MimeHelper {
    private static final SetF<String> allowedForInlineContentDisposition = Cf.set(
            "application/pdf",
            "application/x-google-chrome-print-preview-pdf",
            "application/x-fictionbook+xml",
            "application/x-zip-compressed-fb2",
            "application/epub+zip");

    private static final SetF<String> allowedForInlineContentDispositionForOldWeb = Cf.set(
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            "application/msword",
            "application/vnd.ms-word.document.macroenabled.12",
            "application/vnd.ms-word",
            "application/vnd.ms-word.document.12",
            "application/vnd.msword",
            "application/rtf",
            "text/rtf");

    private boolean isOldWebEnabled;

    public MimeHelper(boolean isOldWebEnabled) {
        this.isOldWebEnabled = isOldWebEnabled;
    }

    public boolean isAllowedForInlineDisposition(String contentType) {
        boolean allowedForOldWeb = isOldWebEnabled && allowedForInlineContentDispositionForOldWeb.containsTs(contentType);
        return allowedForOldWeb || allowedForInlineContentDisposition.containsTs(contentType);
    }
}
