package ru.yandex.chemodan.app.docviewer.copy;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.storage.StorageId;
import ru.yandex.misc.lang.DefaultToString;

/**
 * @author metal
 */
@Data
@AllArgsConstructor
public class StorageResourceInfo extends DefaultToString {
    private final StorageId id;
    private final Option<String> contentDispositionFileName;
    private final Option<String> contentType;
    private final Option<String> encoding;

    public StorageResourceInfo(StorageId id) {
        this(id, Option.empty(), Option.empty(), Option.empty());
    }

    public StorageId getStorageId() {
        return id;
    }

}
