package ru.yandex.chemodan.app.docviewer.copy;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.dao.rights.UriRightsDao;
import ru.yandex.chemodan.app.docviewer.dao.uris.StoredUri;
import ru.yandex.chemodan.app.docviewer.dao.uris.StoredUriDao;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author ssytnik
 */
@RequiredArgsConstructor
public class StoredUriManager {

    private final StoredUriDao storedUriDao;
    private final UriRightsDao uriRightsDao;

    public Option<StoredUri> findByFileIdAndUidO(String fileId, PassportUidOrZero uid) {
        return uriRightsDao
                .findUriByFileIdAndUid(fileId, uid)
                .orElse(() -> {
                    if (uid.isAuthenticated()) {
                        return uriRightsDao.findUriByFileIdAndUid(fileId, PassportUidOrZero.zero());
                    } else {
                        return Option.empty();
                    }
                })
                .flatMapO(storedUriDao::find);
    }

}
