package ru.yandex.chemodan.app.docviewer.copy;

import java.net.URI;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.utils.FileCopy;

/**
 * @author vlsergey
 * @author akirakozov
 * @author ssytnik
 */
@Data
@AllArgsConstructor
public final class TempFileInfo {
    private final Option<String> reportedContentType;
    private final Option<String> contentDispositionFilename;
    private final FileCopy localCopy;
    private final URI uriForLogging;
    private final boolean useUriForMimeType;
    private final CacheResult cacheResult;
    private final Option<Instant> serpLastAccess;

    public TempFileInfo(Option<String> reportedContentType,
            Option<String> contentDispositionFilename,
            FileCopy localCopy, URI uriForLogging, boolean useUriForMimeType,
            Option<Instant> serpLastAccess)
    {
        this(reportedContentType, contentDispositionFilename, localCopy,
                uriForLogging, useUriForMimeType, CacheResult.N_A, serpLastAccess);
    }

    public TempFileInfo withContentDispositionFilename(Option<String> contentDispositionFilename) {
        return new TempFileInfo(reportedContentType, contentDispositionFilename, localCopy,
                uriForLogging, useUriForMimeType, cacheResult, serpLastAccess);
    }

    public TempFileInfo withCacheResult(CacheResult cacheResult) {
        return new TempFileInfo(reportedContentType, contentDispositionFilename, localCopy,
                uriForLogging, useUriForMimeType, cacheResult, serpLastAccess);
    }

    public TempFileInfo withLocalCopy(FileCopy localCopy) {
        return new TempFileInfo(reportedContentType, contentDispositionFilename, localCopy,
                uriForLogging, useUriForMimeType, cacheResult, serpLastAccess);
    }

    public long length() {
        return localCopy.getFile().length();
    }

}
