package ru.yandex.chemodan.app.docviewer.copy.downloader;

import java.net.URI;

import ru.yandex.chemodan.app.docviewer.copy.StorageResourceInfo;
import ru.yandex.chemodan.app.docviewer.copy.TempFileInfo;
import ru.yandex.chemodan.app.docviewer.states.MaxFileSizeChecker;

public interface FileDownloader<T extends FileToDownload> {

    default TempFileInfo download(URI uri, StorageResourceInfo copierResponse, MaxFileSizeChecker sizeChecker) {
        T fileToDownload = buildFileToDownload(uri, copierResponse);
        return download(fileToDownload, sizeChecker);

    }

    TempFileInfo download(T fileToDownload, MaxFileSizeChecker sizeChecker);

    T buildFileToDownload(URI uri, StorageResourceInfo copierResponse);
}
