package ru.yandex.chemodan.app.docviewer.copy.downloader;

import java.net.URI;

import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.storage.StorageId;
import ru.yandex.chemodan.app.docviewer.storages.FileLink;
import ru.yandex.chemodan.app.docviewer.storages.mds.MdsFileLink;
import ru.yandex.chemodan.app.docviewer.storages.mulca.MulcaFileLink;

/**
 * @author metal
 */
@Data
@Builder
public class FileToDownloadViaMulcaClient implements FileToDownload {
    private final URI uri;
    private final StorageId storageId;
    private final Option<String> contentDispositionFilename;
    private final boolean isArchive;

    private final boolean reparse;
    private final Option<String> encoding;
    // albeit it's wierd to have contentType prior to download, this is used to determine max file size
    private final Option<String> contentType;


    @Override
    public FileLink toFileLink() {
        if (getStorageId().isMulcaId()) {
            return new MulcaFileLink(getStorageId().getMulcaId().toSerializedString());
        } else {
            return new MdsFileLink(getStorageId().getMdsFileKey().serialize());
        }
    }
}
