package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class CrmUrlProvider extends DocumentUrlProvider {

    private final String crm;

    public CrmUrlProvider(String crmHost, boolean lite) {
        super(lite ? "ya-crmlite" : "ya-crm");
        String pathPrefix = lite ? "/bo" : "/space";
        this.crm = "https://" + crmHost + pathPrefix + "/download/docviewer";
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String documentId = StringUtils.substringAfter(source.getOriginalUrl(), "://");
        return UrlUtils.addParameter(crm,
                "docid", documentId, "uid", Long.toString(source.getUid().getUid()));
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return Option.empty();
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        return StringUtils.startsWith(actualUri.getUriString(), crm);
    }

    @Override
    public boolean isYaTeamServiceProvider() {
        return true;
    }

}
