package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskPublicFileId;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class DiskPublicUrlProvider extends DiskBaseUrlProvider {

    public DiskPublicUrlProvider(MpfsUrlHelper mpfsUrlHelper) {
        super("ya-disk-public", mpfsUrlHelper);
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String privateHash = StringUtils.substringAfter(source.getOriginalUrl(), "://");
        return mpfsUrlHelper.addUidIfMissing(mpfsUrlHelper.getPublicDirectUrl(privateHash), source.getUid());
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        Option<String> hash = getPrivateHashQueryParameter(uri);
        return hash.isPresent() ? Option.of(new DiskPublicFileId(hash.get())) : Option.empty();
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        String host = actualUri.getUri().getHost();
        Option<String> hash = getPrivateHashQueryParameter(actualUri);
        return StringUtils.equals(mpfsUrlHelper.getMpfsHost(), host) && hash.isPresent();
    }

    private Option<String> getPrivateHashQueryParameter(ActualUri uri) {
        return UrlUtils.getQueryParameterFromUrl(uri.getUriString(), "private_hash");
    }
}
